/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.ItemType;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.ItemEvent;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.items.ItemScripted;

public class ItemScriptedWrapper
extends ItemStackWrapper
implements IItemScripted,
IScriptHandler {
    public int durabilityColor = -1;
    public boolean durabilityShow = true;
    public double durabilityValue = 1.0;
    public boolean enabled = false;
    public int itemColor = -1;
    public long lastInited = -1L;
    public boolean loaded = false;
    public String scriptLanguage = "ECMAScript";
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public int stackSize = 64;
    public boolean updateClient = false;

    public ItemScriptedWrapper(ItemStack item) {
        super(item);
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public int getColor() {
        return this.itemColor;
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                String log = map.containsKey(entry.getKey()) ? map.get(entry.getKey()) + "\n\nScriptTab " + tab + ":\n" + entry.getValue() : " ScriptTab " + tab + ":\n" + entry.getValue();
                map.put(entry.getKey(), log);
            }
        }
        return map;
    }

    @Override
    public void clearConsoleText(Long key) {
        for (ScriptContainer script : this.getScripts()) {
            script.console.remove(key);
        }
    }

    @Override
    public int getDurabilityColor() {
        return this.durabilityColor;
    }

    @Override
    public boolean getDurabilityShow() {
        return this.durabilityShow;
    }

    @Override
    public double getDurabilityValue() {
        return this.durabilityValue;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    @Override
    public int getMaxStackSize() {
        return this.stackSize;
    }

    @Override
    public NBTTagCompound getMCNbt() {
        NBTTagCompound compound = super.getMCNbt();
        this.getScriptNBT(compound);
        compound.func_74757_a("DurabilityShow", this.durabilityShow);
        compound.func_74780_a("DurabilityValue", this.durabilityValue);
        compound.func_74768_a("DurabilityColor", this.durabilityColor);
        compound.func_74768_a("ItemColor", this.itemColor);
        compound.func_74768_a("MaxStackSize", this.stackSize);
        return compound;
    }

    public NBTTagCompound getScriptNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        return compound;
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    @Override
    public String getTexture(int damage) {
        return ItemScripted.Resources.get(damage);
    }

    @Override
    public int getType() {
        return ItemType.SCRIPTED.get();
    }

    @Override
    public boolean hasTexture(int damage) {
        return ItemScripted.Resources.containsKey(damage);
    }

    @Override
    public boolean isClient() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.scripts.isEmpty();
    }

    public void loadScriptData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c == null) {
            return;
        }
        this.setScriptNBT(c.func_74775_l("ScriptedData"));
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        IPlayer<?> iPlayer;
        TextComponentString message = new TextComponentString("Scripted Item Script");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString(" hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        if ((iPlayer = ItemScriptedWrapper.getIPlayer(event)) != null) {
            TextComponentString mesPlayer = new TextComponentString("Player \"");
            mesPlayer.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString name = new TextComponentString(iPlayer.getName());
            name.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
            mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString uuid = new TextComponentString(iPlayer.getUUID());
            uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesEnd = new TextComponentString("\" in ");
            mesEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)mesPlayer).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesEnd);
            int dimID = iPlayer.getWorld().getMCWorld() == null ? 0 : iPlayer.getWorld().getMCWorld().field_73011_w.getDimension();
            double x = (double)Math.round(iPlayer.getPos().getX() * 100.0) / 100.0;
            double y = (double)Math.round(iPlayer.getPos().getX() * 100.0) / 100.0;
            double z = (double)Math.round(iPlayer.getPos().getX() * 100.0) / 100.0;
            TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
            posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + y + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
            message = message.func_150257_a((ITextComponent)posClick);
        }
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)side);
    }

    private static IPlayer<?> getIPlayer(Object event) {
        if (event instanceof ItemEvent.AttackEvent) {
            return ((ItemEvent.AttackEvent)((Object)event)).player;
        }
        if (event instanceof ItemEvent.InteractEvent) {
            return ((ItemEvent.InteractEvent)((Object)event)).player;
        }
        if (event instanceof ItemEvent.PickedUpEvent) {
            return ((ItemEvent.PickedUpEvent)((Object)event)).player;
        }
        if (event instanceof ItemEvent.TossedEvent) {
            return ((ItemEvent.TossedEvent)((Object)event)).player;
        }
        if (event instanceof ItemEvent.UpdateEvent) {
            return ((ItemEvent.UpdateEvent)((Object)event)).player;
        }
        return null;
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.loaded) {
            this.loadScriptData();
            this.loaded = true;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onScriptItemInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    public void saveScriptData() {
        NBTTagCompound c = this.item.func_77978_p();
        if (c == null) {
            c = new NBTTagCompound();
            this.item.func_77982_d(c);
        }
        c.func_74782_a("ScriptedData", (NBTBase)this.getScriptNBT(new NBTTagCompound()));
    }

    @Override
    public void setColor(int color) {
        if (color != this.itemColor) {
            this.updateClient = true;
        }
        this.itemColor = color;
    }

    @Override
    public void setDurabilityColor(int color) {
        if (color != this.durabilityColor) {
            this.updateClient = true;
        }
        this.durabilityColor = color;
    }

    @Override
    public void setDurabilityShow(boolean bo) {
        if (bo != this.durabilityShow) {
            this.updateClient = true;
        }
        this.durabilityShow = bo;
    }

    @Override
    public void setDurabilityValue(float value) {
        if ((double)value != this.durabilityValue) {
            this.updateClient = true;
        }
        this.durabilityValue = value;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setLastInited(long timeMC) {
        this.lastInited = timeMC;
    }

    @Override
    public void setMaxStackSize(int size) {
        if (size < 1 || size > 64) {
            throw new CustomNPCsException("Stacksize has to be between 1 and 64", new Object[0]);
        }
        this.stackSize = size;
    }

    @Override
    public void setMCNbt(NBTTagCompound compound) {
        super.setMCNbt(compound);
        this.setScriptNBT(compound);
        this.durabilityShow = compound.func_74767_n("DurabilityShow");
        this.durabilityValue = compound.func_74769_h("DurabilityValue");
        if (compound.func_74764_b("DurabilityColor")) {
            this.durabilityColor = compound.func_74762_e("DurabilityColor");
        }
        this.itemColor = compound.func_74762_e("ItemColor");
        this.stackSize = compound.func_74762_e("MaxStackSize");
    }

    public void setScriptNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("Scripts")) {
            return;
        }
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
    }

    @Override
    public void setTexture(int damage, String texture) {
        if (damage == 0) {
            throw new CustomNPCsException("Can't set texture for 0", new Object[0]);
        }
        String old = ItemScripted.Resources.get(damage);
        if (Objects.equals(old, texture)) {
            return;
        }
        ItemScripted.Resources.put(damage, texture);
        SyncController.syncScriptItemsEverybody();
    }
}

